#which library
fastqDir="~/MIP_data_and_analysis/Accessions"

#for each library (such as 96 accessions)
for lib in `ls $fastqDir`
do
	libDir=$fastqDir/$lib
	#make a directory called degen_counts
	mkdir $libDir/degen_counts
	#for each .sam file
	for sam in `ls $libDir/alignments | grep .sam`
	do	
		countsfile=`echo $sam | cut -f 1 -d . -`
		fastq_prefix=`echo ${countsfile}_`
		fastq_name=`ls $libDir/$fastq_prefix*_2.fastq`
		#run this python script which parses the same file to call repeats and sort into tag-defined read groups
		python sorting_degens.py $libDir/alignments/$sam  $libDir/degen_counts/${countsfile}.txt $fastq_name $fastq_prefix
		if [ $? -ne 0 ]
		then
			echo $lib $sam
		fi
	done
done

